<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Protfolio extends Model 
{

    protected $table = 'protfolios';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('App\models\Company');
    }

    public function attachments()
    {
        return $this->morphMany('App\models\Attachment');
    }

    public function refrences()
    {
        return $this->hasMany('App\models\ProtfolioRefrence');
    }

    public function owners()
    {
        return $this->hasMany('App\models\ProtfolioOwners');
    }

    public function block()
    {
        return $this->belongsTo('App\models\Block');
    }

    public function properties()
    {
        return $this->hasMany('App\models\Property');
    }

}